#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
机械特征基础模块，定义基础特征类和类型
"""

import logging

# 定义特征类型（中文）
特征类型 = {
    '孔': '孔',
    '凹槽': '凹槽',
    '凸台': '凸台',
    '槽': '槽',
    '倒角': '倒角',
    '圆角': '圆角',
    '螺纹': '螺纹',
    '筋': '筋',
    '沟槽': '沟槽', 
    '平面': '平面',
    '圆柱面': '圆柱面',
    '圆锥面': '圆锥面',
    '球面': '球面',
    '环面': '环面',
    '旋转面': '旋转面',
    '拉伸面': '拉伸面',
    '贝塞尔曲面': '贝塞尔曲面',
    'B样条曲面': 'B样条曲面',
    '未知': '未知'
}

logger = logging.getLogger(__name__)

class 机械特征:
    """机械特征基类"""
    
    def __init__(self, 特征类型, 形状, 属性=None):
        """
        初始化特征
        
        Args:
            特征类型 (str): 特征类型
            形状: 特征对应的OCC形状
            属性 (dict, optional): 特征属性
        """
        self.特征类型 = 特征类型
        self.形状 = 形状
        self.属性 = 属性 or {}
        
    def __str__(self):
        """返回特征的字符串表示"""
        属性字符串 = ", ".join([f"{k}: {v}" for k, v in self.属性.items()])
        return f"{self.特征类型}特征: {属性字符串}"