# CAD特征识别系统 - 更新说明

## 版本: 2.0

## 更新内容

### 1. 孔特征分析器 (feature_analyzer_hole.py) - 重大改进

#### 1.1 孔识别判断 `is_hole()`
**四重策略综合判断：**

- **策略1 - 多点采样检测空腔（96个采样点）**
  - 4种半径比例 × 8个角度 × 3个轴向位置
  - 空腔比例 > 60% → 判定为孔

- **策略2 - 轴向开口检测**
  - 沿轴向正负两个方向，在不同距离检测是否到达形状外部
  - 在每个轴向位置的圆周上采样8个点验证

- **策略3 - 参数域分析**
  - U方向参数范围 > 1.5π 且空腔比例 > 30% → 孔

- **策略4 - 边界特征检查**
  - 检测完整圆形边缘、部分圆弧、边缘数量

#### 1.2 深度计算改进 `_get_hole_position_and_depth_from_bounds()`

**问题诊断：** `cylinder.Location()` 返回STEP文件中轴线的参考点，不是实际几何位置

**修复方案：**
```python
# 方法1: 从圆柱面边界圆提取实际位置
boundary_positions = []  # 提取所有Circle边界的圆心
if len(boundary_positions) >= 2:
    center = (p1 + p2) / 2  # 两个边界圆的中点
    depth = np.linalg.norm(p2 - p1)  # 两圆心距离

# 方法2: 从V参数域计算
depth = abs(v_max - v_min)

# 方法3: 使用参数域中点作为起始点
v_mid = (v_min + v_max) / 2
center_point = surf.Value(0, v_mid)
```

**双阶段搜索：**
- 粗搜索（大步长）快速定位边界区域
- 细搜索（小步长0.1mm）精确定位边界位置

#### 1.3 通孔/盲孔判断改进 `_determine_hole_type()`

**新增边界连接分析：**
```python
# 对每个圆形边界，检查连接的面类型
for circular_edge in circular_edges:
    connected_face_type = _get_connected_face_type(edge)
    if connected_face_type == 'cone':   # 连接锥面 → 封闭端
    elif connected_face_type == 'plane': # 连接平面 → 封闭端  
    elif connected_face_type == 'open':  # 无连接 → 开放端

# 判断逻辑
if both_ends_closed: return '盲孔'
if one_end_closed: return '盲孔'
if both_ends_open: return '通孔'
```

### 2. 新增内六角特征分析器 (feature_analyzer_hexsocket.py)

识别内六角槽特征：
- 检测6个等面积平面呈60°均匀分布
- 计算对边距离
- 匹配标准内六角尺寸（M1.6-M24）
- 检测入口倒角

**标准尺寸对照表：**
| 螺钉规格 | 对边距离(mm) |
|---------|-------------|
| M3      | 2.5         |
| M4      | 3.0         |
| M5      | 4.0         |
| M6      | 5.0         |
| M8      | 6.0         |
| M10     | 8.0         |
| M12     | 10.0        |

### 3. 新增语义特征分析器 (feature_semantic_analyzer.py)

将基础几何特征组合为高级语义特征：

- **ISO简化螺纹识别**
  - 识别30°大半径锥面（R>100mm）
  - 验证与圆柱面的相邻关系
  - 匹配标准螺纹规格

- **沉头孔识别**
  - 识别圆柱孔+锥面入口组合
  - 支持82°、90°、120°标准沉头角度

- **台阶孔识别**
  - 识别同轴不同直径的圆柱面组合

- **凹端锥坑识别**
  - 识别小半径45°/60°锥面

### 4. 凸台分析器改进 (feature_analyzer_boss.py)

- 修复双重`@staticmethod`装饰器
- 增强凹凸判断避免与内六角槽混淆
- 新增`_looks_like_hex_socket()`方法检测类似内六角的结构
- 增加面积比例检查

### 5. 特征分析主模块更新 (feature_analyzer.py)

新增方法：
- `find_hex_sockets(shape)` - 查找内六角特征
- `analyze_hex_socket(hex_faces, shape)` - 分析内六角属性
- `is_hex_socket_face(face, shape)` - 判断是否内六角面
- `analyze_semantic_features(features, shape)` - 语义特征分析
- `analyze_cone_semantics(cone_face, shape)` - 锥面语义分析

## 文件清单

| 文件名 | 状态 | 说明 |
|-------|------|------|
| feature_analyzer_hole.py | 重写 | 孔特征分析 |
| feature_analyzer_hexsocket.py | 新增 | 内六角特征分析 |
| feature_semantic_analyzer.py | 新增 | 语义特征分析 |
| feature_analyzer_boss.py | 更新 | 凸台分析，修复bug |
| feature_analyzer.py | 更新 | 添加新分析方法 |
| feature_analyzer_pocket.py | 保持 | 凹槽分析 |
| feature_analyzer_rib.py | 保持 | 筋分析 |
| feature_analyzer_groove.py | 保持 | 沟槽分析 |
| feature_analyzer_thread.py | 保持 | 螺纹分析 |
| feature_analyzer_fillet.py | 保持 | 圆角倒角分析 |
| feature_analyzer_geometry.py | 保持 | 几何分析 |
| feature_recognition.py | 保持 | 特征识别主模块 |
| feature_topology.py | 保持 | 拓扑关系分析 |
| feature_writer.py | 保持 | 特征输出 |
| feature_base.py | 保持 | 基础定义 |
| feature_protrusion_analyzer.py | 保持 | 凸起/凹陷分析 |
| thread_analysis_utils.py | 保持 | 螺纹分析工具 |
| thread_verification.py | 保持 | 螺纹验证 |
| thread_standards.py | 保持 | 螺纹标准数据 |
| feature_b.py | 保持 | B样条曲面参数提取 |

## 使用示例

### 孔特征识别
```python
from feature_analyzer import FeatureAnalyzer

# 判断是否为孔
if FeatureAnalyzer.is_hole(cylindrical_face, shape):
    # 分析孔属性
    hole_props = FeatureAnalyzer.analyze_hole(cylindrical_face, shape)
    print(f"孔直径: {hole_props['直径']}mm")
    print(f"孔深度: {hole_props['深度']}mm")
    print(f"孔类型: {hole_props['孔类型']}")
```

### 内六角识别
```python
from feature_analyzer import FeatureAnalyzer

# 查找内六角特征
hex_sockets = FeatureAnalyzer.find_hex_sockets(shape)
for hex_socket in hex_sockets:
    print(f"内六角规格: {hex_socket['标准规格']}")
    print(f"对边距离: {hex_socket['对边距离']}mm")
```

### 语义特征分析
```python
from feature_analyzer import FeatureAnalyzer

# 分析语义特征
semantic_features = FeatureAnalyzer.analyze_semantic_features(features, shape)
for feature in semantic_features:
    if feature['类型'] == 'ISO简化螺纹':
        print(f"螺纹规格: {feature['公称规格']}")
    elif feature['类型'] == '沉头孔':
        print(f"沉头角度: {feature['沉头角度']}°")
```

## 测试建议

针对内六角紧定螺钉（如PSJP-M10-20-A）的测试：

1. **孔特征测试**
   - 验证位置计算是否正确（应在零件中部，不是轴线参考点）
   - 验证深度计算（应为实际槽深，约17mm）
   - 验证孔类型判断（应为盲孔）

2. **内六角特征测试**
   - 验证是否识别到6个平面
   - 验证对边距离计算
   - 验证标准规格匹配

3. **锥面语义分析测试**
   - 大半径30°锥面应识别为ISO简化螺纹
   - 小半径45°锥面应识别为倒角或锥坑
