@echo off
REM PRT特征识别API服务启动脚本 (Windows)

echo ============================================================
echo PRT特征识别API服务
echo ============================================================
echo.

REM 检查conda环境
call conda activate prt_api
if errorlevel 1 (
    echo 错误: 找不到conda环境 'prt_api'
    echo 请先运行: conda create -n prt_api python=3.9
    echo 然后安装依赖: conda install -c conda-forge pythonocc-core
    pause
    exit /b 1
)

echo 环境: prt_api
echo Python版本:
python --version
echo.

REM 设置参数
set HOST=0.0.0.0
set PORT=8000
set WORKERS=1

echo 启动参数:
echo   - 地址: %HOST%
echo   - 端口: %PORT%
echo   - 工作进程: %WORKERS%
echo.

echo 启动服务中...
echo API文档: http://localhost:%PORT%/docs
echo 健康检查: http://localhost:%PORT%/health
echo.

REM 启动服务
python prt_feature_api.py --host %HOST% --port %PORT% --workers %WORKERS%

pause
