#!/bin/bash
# PRT特征识别API服务启动脚本 (Linux/Mac)

echo "============================================================"
echo "PRT特征识别API服务"
echo "============================================================"
echo ""

# 检查conda环境
if ! conda env list | grep -q "prt_api"; then
    echo "错误: 找不到conda环境 'prt_api'"
    echo "请先运行: conda create -n prt_api python=3.9"
    echo "然后安装依赖: conda install -c conda-forge pythonocc-core"
    exit 1
fi

# 激活环境
source $(conda info --base)/etc/profile.d/conda.sh
conda activate prt_api

echo "环境: prt_api"
echo "Python版本:"
python --version
echo ""

# 设置参数
HOST=${HOST:-0.0.0.0}
PORT=${PORT:-8000}
WORKERS=${WORKERS:-4}

echo "启动参数:"
echo "  - 地址: $HOST"
echo "  - 端口: $PORT"
echo "  - 工作进程: $WORKERS"
echo ""

echo "启动服务中..."
echo "API文档: http://localhost:$PORT/docs"
echo "健康检查: http://localhost:$PORT/health"
echo ""

# 启动服务（生产模式）
if command -v gunicorn &> /dev/null; then
    echo "使用Gunicorn多进程模式"
    gunicorn prt_feature_api:app \
        -w $WORKERS \
        -k uvicorn.workers.UvicornWorker \
        --bind $HOST:$PORT \
        --access-logfile - \
        --error-logfile -
else
    echo "使用Uvicorn单进程模式"
    python prt_feature_api.py --host $HOST --port $PORT --workers 1
fi
