# PRT特征识别API服务配置文件示例
# 复制此文件为 config.py 并根据需要修改

# ==================== 服务配置 ====================

# 服务地址和端口
API_HOST = "0.0.0.0"
API_PORT = 8000

# 工作进程数（仅Linux/Mac的gunicorn模式）
WORKERS = 4

# 是否启用热重载（开发模式）
RELOAD = False

# ==================== 主板验证配置 ====================

# 授权主板UID
AUTHORIZED_UID = "024AFQCNL8002172"

# 是否启用主板验证
ENABLE_MOTHERBOARD_VERIFICATION = True

# 开发模式（跳过主板验证）
DEVELOPMENT_MODE = False

# ==================== 文件处理配置 ====================

# 临时文件目录
TEMP_DIR = "/tmp/prt_feature_api"

# 最大文件大小（MB）
MAX_FILE_SIZE_MB = 500

# 允许的文件扩展名
ALLOWED_EXTENSIONS = [".stp", ".step", ".prt"]

# ==================== 任务管理配置 ====================

# 任务默认超时时间（秒）
JOB_TIMEOUT = 3600

# 任务清理时间（小时）
JOB_MAX_AGE_HOURS = 24

# 自动清理间隔（小时）
AUTO_CLEANUP_INTERVAL = 6

# ==================== 特征提取配置 ====================

# 默认启用拓扑关系分析
DEFAULT_ENABLE_TOPOLOGY = True

# 默认启用工艺规划
DEFAULT_ENABLE_PROCESS_PLANNING = False

# 默认材料类型
DEFAULT_MATERIAL = "steel"

# 支持的材料类型
SUPPORTED_MATERIALS = [
    "steel",
    "aluminum",
    "cast_iron",
    "stainless_steel",
    "titanium"
]

# ==================== 日志配置 ====================

# 日志级别
LOG_LEVEL = "INFO"  # DEBUG, INFO, WARNING, ERROR, CRITICAL

# 日志格式
LOG_FORMAT = "%(asctime)s - %(name)s - %(levelname)s - %(message)s"

# 日志文件
LOG_FILE = "prt_feature_api.log"

# 是否启用文件日志
ENABLE_FILE_LOGGING = True

# ==================== CORS配置 ====================

# 允许的源
CORS_ORIGINS = ["*"]

# 允许的方法
CORS_METHODS = ["*"]

# 允许的头部
CORS_HEADERS = ["*"]

# 是否允许凭证
CORS_ALLOW_CREDENTIALS = True

# ==================== API限流配置 ====================

# 是否启用限流
ENABLE_RATE_LIMIT = False

# 限流规则（每分钟请求次数）
RATE_LIMIT_PER_MINUTE = 60

# ==================== 数据库配置（可选）====================

# 如需持久化任务状态，可配置数据库
# 当前版本使用内存存储

# 数据库类型
# DB_TYPE = "sqlite"  # sqlite, postgresql, mysql

# 数据库连接字符串
# DB_CONNECTION_STRING = "sqlite:///./prt_feature_api.db"

# ==================== 性能优化配置 ====================

# 特征提取线程数
FEATURE_EXTRACTION_THREADS = 4

# 内存限制（MB）
MEMORY_LIMIT_MB = 4096

# 是否启用缓存
ENABLE_CACHE = False

# 缓存过期时间（秒）
CACHE_EXPIRY_SECONDS = 3600

# ==================== 通知配置（可选）====================

# 任务完成通知
ENABLE_NOTIFICATIONS = False

# 通知方式：email, webhook
NOTIFICATION_METHOD = "webhook"

# Webhook URL
WEBHOOK_URL = "http://your-webhook-endpoint.com/notify"

# ==================== 监控配置（可选）====================

# 是否启用Prometheus监控
ENABLE_PROMETHEUS = False

# Prometheus端口
PROMETHEUS_PORT = 9090

# ==================== 安全配置 ====================

# API密钥验证（可选）
ENABLE_API_KEY = False

# API密钥
API_KEYS = [
    "your-api-key-1",
    "your-api-key-2"
]

# JWT认证（可选）
ENABLE_JWT = False

# JWT密钥
JWT_SECRET_KEY = "your-secret-key-change-this"

# JWT过期时间（小时）
JWT_EXPIRY_HOURS = 24

# ==================== Creo配置 ====================

# Creo可执行文件路径
CREO_EXECUTABLE = r"D:\apps\ptc\Creo 12.4.0.0\Parametric\bin\parametric.exe"

# Creo批处理模式参数
CREO_BATCH_PARAMS = "-batch_mode -g:no_graphics -i:rpc_input"

# PRT转STEP工具路径
PRT_TO_STEP_TOOL = r".\ExChange.exe"
