# 部署检查清单

## 开发环境部署

### 环境准备
- [ ] 已安装Miniconda/Anaconda
- [ ] 已创建conda环境 `prt_api`
- [ ] 已安装PythonOCC: `conda install -c conda-forge pythonocc-core`
- [ ] 已安装依赖: `pip install -r requirements.txt`

### 文件清单
- [ ] prt_feature_api.py（主服务文件）
- [ ] prt_api_client.py（客户端工具）
- [ ] requirements.txt（依赖列表）
- [ ] config.example.py（配置示例）
- [ ] README.md（使用文档）
- [ ] QUICKSTART.md（快速开始）
- [ ] start_api.bat（Windows启动脚本）
- [ ] start_api.sh（Linux/Mac启动脚本）

### 依赖检查
```bash
conda activate prt_api
python -c "from OCC.Core.STEPControl import STEPControl_Reader; print('✓ PythonOCC')"
python -c "import fastapi; print('✓ FastAPI')"
python -c "import uvicorn; print('✓ Uvicorn')"
```

### 服务启动
```bash
# Windows
start_api.bat

# Linux/Mac
./start_api.sh
```

### 功能测试
- [ ] 访问 http://localhost:8000/health 返回健康状态
- [ ] 访问 http://localhost:8000/docs 显示API文档
- [ ] 上传测试文件成功
- [ ] 任务状态查询正常
- [ ] 结果下载成功

---

## 生产环境部署

### 系统要求
- [ ] CPU: 4核以上
- [ ] 内存: 8GB以上
- [ ] 磁盘: 50GB以上可用空间
- [ ] 操作系统: Linux（推荐）/ Windows Server

### 安全配置
- [ ] 修改默认主板UID或启用API密钥验证
- [ ] 配置防火墙规则
- [ ] 设置文件上传大小限制
- [ ] 启用HTTPS（使用Nginx反向代理）
- [ ] 配置CORS白名单

### 性能优化
- [ ] 设置合适的worker进程数（CPU核心数×2）
- [ ] 配置任务自动清理策略
- [ ] 启用日志文件轮转
- [ ] 设置内存限制
- [ ] 配置临时文件清理定时任务

### 反向代理配置（Nginx示例）
```nginx
server {
    listen 80;
    server_name your-domain.com;
    
    location / {
        proxy_pass http://127.0.0.1:8000;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        
        # 文件上传大小限制
        client_max_body_size 500M;
        
        # 超时设置
        proxy_connect_timeout 600s;
        proxy_send_timeout 600s;
        proxy_read_timeout 600s;
    }
}
```

### 进程管理（Systemd示例）
```ini
[Unit]
Description=PRT Feature API Service
After=network.target

[Service]
Type=simple
User=your-user
WorkingDirectory=/path/to/prt_api_service
Environment="PATH=/home/your-user/miniconda3/envs/prt_api/bin"
ExecStart=/home/your-user/miniconda3/envs/prt_api/bin/gunicorn prt_feature_api:app -w 4 -k uvicorn.workers.UvicornWorker --bind 127.0.0.1:8000
Restart=always
RestartSec=10

[Install]
WantedBy=multi-user.target
```

### 监控配置
- [ ] 配置日志收集（Elasticsearch/ELK）
- [ ] 设置性能监控（Prometheus + Grafana）
- [ ] 配置告警通知（钉钉/企业微信/邮件）
- [ ] 设置健康检查定时任务

### 备份策略
- [ ] 定期备份任务结果
- [ ] 备份配置文件
- [ ] 备份日志文件
- [ ] 设置自动备份脚本

---

## Docker部署

### 准备工作
- [ ] 已安装Docker
- [ ] 已安装Docker Compose
- [ ] 已准备Dockerfile和docker-compose.yml

### 构建镜像
```bash
docker-compose build
```

### 启动服务
```bash
docker-compose up -d
```

### 验证
```bash
# 查看容器状态
docker-compose ps

# 查看日志
docker-compose logs -f

# 健康检查
curl http://localhost:8000/health
```

### 容器管理
```bash
# 停止服务
docker-compose stop

# 重启服务
docker-compose restart

# 删除容器
docker-compose down
```

---

## 测试清单

### 功能测试
- [ ] 健康检查接口正常
- [ ] 文件上传功能正常
- [ ] 特征提取功能正常
- [ ] 任务状态查询正常
- [ ] 结果下载功能正常
- [ ] 任务删除功能正常
- [ ] 任务清理功能正常

### 性能测试
- [ ] 单个小文件（<10MB）处理时间 < 30秒
- [ ] 单个大文件（100-500MB）处理时间 < 5分钟
- [ ] 并发10个请求无错误
- [ ] 长时间运行无内存泄漏

### 异常测试
- [ ] 上传非STEP/PRT文件被拒绝
- [ ] 上传超大文件被拒绝
- [ ] 无效job_id返回404
- [ ] 主板UID不匹配时拒绝服务

### 兼容性测试
- [ ] Windows系统正常运行
- [ ] Linux系统正常运行
- [ ] Docker容器正常运行
- [ ] 不同浏览器API文档正常显示

---

## 上线前最后检查

### 配置检查
- [ ] 主板UID验证已正确配置
- [ ] 日志级别设置为INFO或WARNING
- [ ] 文件大小限制已设置
- [ ] 任务清理策略已配置
- [ ] 临时目录路径正确

### 安全检查
- [ ] 不包含测试用API密钥
- [ ] 敏感信息已从代码中移除
- [ ] CORS策略已正确配置
- [ ] 文件上传安全验证已启用
- [ ] 错误信息不泄露敏感数据

### 文档检查
- [ ] README.md完整且准确
- [ ] QUICKSTART.md可用
- [ ] API文档自动生成正常
- [ ] 配置文件示例完整

### 备份检查
- [ ] 代码已提交到版本控制
- [ ] 配置文件已备份
- [ ] 部署脚本已备份
- [ ] 重要文档已备份

---

## 维护计划

### 日常维护
- [ ] 每天检查服务运行状态
- [ ] 每天查看错误日志
- [ ] 每周清理旧任务文件
- [ ] 每周检查磁盘空间

### 定期维护
- [ ] 每月更新依赖包
- [ ] 每月分析性能指标
- [ ] 每季度进行安全审计
- [ ] 每半年进行代码重构

### 应急响应
- [ ] 准备回滚方案
- [ ] 准备故障排查手册
- [ ] 建立问题反馈渠道
- [ ] 设置应急联系人

---

## 验收标准

### 功能完整性
- ✓ 所有API端点正常工作
- ✓ 特征识别准确率 > 95%
- ✓ 文件格式支持完整

### 性能指标
- ✓ API响应时间 < 100ms
- ✓ 文件处理成功率 > 99%
- ✓ 并发处理能力 > 10 QPS

### 稳定性
- ✓ 7×24小时运行无重启
- ✓ 内存使用稳定
- ✓ 错误率 < 1%

### 安全性
- ✓ 通过安全扫描
- ✓ 无已知漏洞
- ✓ 访问控制有效

---

**完成以上检查后，即可正式上线！**
