# 快速开始指南

## 一、环境准备（5分钟）

### Windows用户

```bash
# 1. 安装Miniconda（如果还没有）
# 下载: https://docs.conda.io/en/latest/miniconda.html

# 2. 创建并激活环境
conda create -n prt_api python=3.9 -y
conda activate prt_api

# 3. 安装PythonOCC
conda install -c conda-forge pythonocc-core -y

# 4. 安装其他依赖
pip install -r requirements.txt
```

### Linux/Mac用户

```bash
# 1. 创建并激活环境
conda create -n prt_api python=3.9 -y
conda activate prt_api

# 2. 安装PythonOCC
conda install -c conda-forge pythonocc-core -y

# 3. 安装其他依赖
pip install -r requirements.txt
```

## 二、启动服务（1分钟）

### 方式1: 使用启动脚本

**Windows:**
```bash
start_api.bat
```

**Linux/Mac:**
```bash
chmod +x start_api.sh
./start_api.sh
```

### 方式2: 直接命令行

```bash
conda activate prt_api
python prt_feature_api.py --host 0.0.0.0 --port 8000
```

### 方式3: 使用Docker

```bash
# 构建并启动
docker-compose up -d

# 查看日志
docker-compose logs -f
```

## 三、验证服务（30秒）

### 浏览器访问

1. 打开浏览器，访问: http://localhost:8000/docs
2. 你会看到Swagger UI界面
3. 点击 "GET /health" -> "Try it out" -> "Execute"
4. 看到 `"status": "healthy"` 表示服务正常

### 命令行验证

```bash
curl http://localhost:8000/health
```

## 四、第一个API调用（2分钟）

### 使用Swagger UI（推荐新手）

1. 访问 http://localhost:8000/docs
2. 找到 "POST /api/v1/extract/upload"
3. 点击 "Try it out"
4. 点击 "Choose File" 选择你的 .stp 或 .prt 文件
5. 点击 "Execute"
6. 记录返回的 `job_id`
7. 使用 "GET /api/v1/jobs/{job_id}" 查询任务状态
8. 任务完成后，使用 "GET /api/v1/jobs/{job_id}/result" 下载结果

### 使用Python客户端

```python
from prt_api_client import PRTFeatureAPIClient

# 创建客户端
client = PRTFeatureAPIClient("http://localhost:8000")

# 上传文件
job_info = client.upload_file("your_model.stp")
job_id = job_info['job_id']
print(f"任务ID: {job_id}")

# 等待完成
status = client.wait_for_completion(job_id)
print(f"任务状态: {status['status']}")

# 获取结果
if status['status'] == 'completed':
    result = client.get_job_result(job_id, "result.json")
    print("✓ 特征提取完成！")
```

### 使用curl

```bash
# 1. 上传文件
curl -X POST "http://localhost:8000/api/v1/extract/upload" \
  -F "file=@model.stp" \
  -F "enable_topology_relations=true"

# 返回: {"job_id": "xxx-xxx-xxx", ...}

# 2. 查询状态（替换下面的job_id）
curl http://localhost:8000/api/v1/jobs/YOUR_JOB_ID

# 3. 下载结果（任务完成后）
curl http://localhost:8000/api/v1/jobs/YOUR_JOB_ID/result -o result.json
```

## 五、使用Postman（可选）

1. 打开Postman
2. Import -> Upload Files
3. 选择 `PRT_Feature_API.postman_collection.json`
4. 修改环境变量 `base_url` 为你的服务地址
5. 按顺序执行请求

## 六、常见问题

### Q: 服务启动失败，提示找不到OCC模块

**A:** 需要安装PythonOCC
```bash
conda install -c conda-forge pythonocc-core -y
```

### Q: 主板UID验证失败

**A:** 
- 确认是否在授权计算机上运行
- 或修改代码中的 `AUTHORIZED_UID`
- 或设置 `DEVELOPMENT_MODE = True` 跳过验证

### Q: 文件上传后任务一直是pending状态

**A:** 查看服务日志，可能是：
- 文件格式不支持
- 文件过大
- 服务处理异常

### Q: 如何增加并发处理能力？

**A:** 增加worker进程数（仅Linux/Mac）
```bash
./start_api.sh  # 默认4个workers

# 或手动指定
export WORKERS=8
./start_api.sh
```

### Q: 如何修改服务端口？

**A:** 
```bash
# 方式1: 环境变量
export PORT=9000
./start_api.sh

# 方式2: 命令行参数
python prt_feature_api.py --port 9000
```

## 七、下一步

- 阅读完整的 [README.md](README.md) 了解所有功能
- 查看 [配置文件示例](config.example.py) 进行定制
- 研究返回的JSON结果格式
- 集成到你的应用中

## 八、技术支持

如遇到问题：
1. 查看服务日志
2. 访问 http://localhost:8000/health 检查状态
3. 确认文件格式正确（.stp, .step, .prt）
4. 联系项目维护者

---

**祝使用愉快！🎉**
