#!/bin/bash
# 三维模型智能搜索系统 - 快速启动脚本

echo "=============================================="
echo "  三维模型智能搜索系统 (LLM增强版)"
echo "=============================================="

# 检查Python
if ! command -v python3 &> /dev/null; then
    echo "❌ Python3 未安装"
    exit 1
fi

# 检查依赖
echo "📦 检查依赖..."
pip3 install -q fastapi uvicorn numpy pydantic 2>/dev/null

# 检查LLM配置
echo ""
echo "🤖 LLM配置检查:"
if [ -n "$ANTHROPIC_API_KEY" ]; then
    echo "  ✓ ANTHROPIC_API_KEY 已设置"
    LLM_AVAILABLE=true
elif [ -n "$OPENAI_API_KEY" ]; then
    echo "  ✓ OPENAI_API_KEY 已设置"
    pip3 install -q openai 2>/dev/null
    LLM_AVAILABLE=true
else
    echo "  ⚠ 未检测到API Key，将使用规则引擎模式"
    echo "  提示: export ANTHROPIC_API_KEY=your_key"
    LLM_AVAILABLE=false
fi

# 安装LLM依赖
if [ "$LLM_AVAILABLE" = true ]; then
    echo ""
    echo "📦 安装LLM依赖..."
    pip3 install -q anthropic 2>/dev/null
fi

# 创建数据目录
mkdir -p data

# 启动服务
echo ""
echo "🚀 启动服务..."
echo "   API文档: http://localhost:8000/docs"
echo "   健康检查: http://localhost:8000/"
echo ""
echo "按 Ctrl+C 停止服务"
echo "=============================================="
echo ""

python3 api_server_enhanced.py
